.TH "Networking" "7" "March 31" "disam_net" "Byte Designs DISAM"


.SH Quick Start Details
.PP
From the client side there are two ways to connect:
.PP
An environment variable provides the option of a default host (which may
be overloaded by directly specifying the host in the filename) and also
makes it easy to redirect your entire application to different hosts.
.PP
environment variable: \fCDISAMNET=[user@]my.host.com[:port]\fP
.PP
or
.PP
filename prefix: \fCdisam://[[user@]my.host.com[:port]]/path/to/isam/file\fP
.PP
Where host can be in \fC123.4.5.6\fP notation also, slashes can be forward or
backward, and prefix is not case sensitive.
.PP
\fCdisam://\fP files override \fCDISAMNET\fP, and \fCDISAMNET\fP overrides local files.
.PP
\fCdisam:///my/local/file\fP will force local files, when \fCDISAMNET\fP is set.
.PP
\fCdisam://[URL]//my/root/path\fP will force root access, whereas any single
slash paths will be taken as relative to the current working directory of
the server process.
.PP
\fCDOS\fP paths with drive letters are also acceptable on server platforms that
can handle this notation.
.PP
\fCuser@host\fP creates an executed pipe connection, by default ssh, in place
of the default socket connection, and this in turn can be over-ridden by
setting \fCDISAMSSH=[/path/to/local/]executable\fP, see details below.
.PP
The underlying logic of the disam URL syntax is that the first character
must be a slash, in either direction, immediately followed by another in
the same direction, followed by a string of any length, followed by one
final terminating slash, in the same direction.
.SS Examples
.PP
.nf
\fC
   DISAMNET=my.lan.server dcheck my_lan_file

   dcheck DISAM://my.lan.server/my_lan_file

   DISAMNET=joe@my.remote.host dcheck my_remote_file

   dcheck DISAM://joe@my.remote.host/my_remote_file
\fP
.fi
.PP
\fBPlease Note\fP that disamnet will accept both full and relative paths in
filenames, meaning that \fCDISAM://server.lan/my_file\fP points to a file in
the current working directory of the server process on server.lan, whereas
\fCDISAM://server.lan//tmp/my_file\fP points to a file in the \fC/tmp\fP directory
of the server.
.SH Overview of the Protocol
.PP
DISAMNET is designed to operate over a full duplex pair from the ground up
to get the best performance out of local area networks, and also to supply
full bandwidth standard in/out communications for easy and/or direct links
over a wide range of options.
.PP
Connections at the moment are either TCP/IP \fIsocket(2)\fP calls to a disamnet
server, or \fIpipe(2)\fP handles to an executable proxy - the default is ssh.
.SS Socket Protocol
.PP
On connecting to the given server port number the client opens the first
handle for reading, and reads two bytes in machine independant order, to
determine the second connection port on which to open the second handle,
and to which it writes an endian order check integer (short value \fC0x1234\fP)
to initiate service.
.PP
At the moment the next highest port number is used for the second socket,
but other strategies are planned for, and will probably be required.
.PP
Socket connections require that clients are able to reach both ports on
your server, so when making adjustments to firewalls, please remember to
configure both ports.
.SS Pipe Protocol
.PP
Both handles are opened in the normal \fIdup2(2)\fP manner, and the client then
sends the endian order check value directly, to initiate service.
.PP
The default pipe call is ssh, unless \fCDISAMSSH\fP is set in the environment,
in which case the call is \fC$DISAMSSH <user@host> [port]\fP.
.PP
The default ssh call expects that disamnet will be found in the user path,
and also that either ssh(1) authentication has already been sorted out, or
your application is otherwise able to handle the user intervention needed
to get authenticated.
.SH Configuration
.PP
Please also see isconfig.h\&
.SM [1]
\&
.br
\&
.SM [1]
\& disam_install.7.man
.br
.PP
You can change the environment keywords and default port numbers here.
.PP
\fBPlease Note\fP
.PP
\fCISADMIN\fP 1 in \fCisconfig.h\fP is \fBmandatory\fP - disamnet relies on isadmin ID.
.PP
\fCutil/disamnet.c\fP includes the same internal module - \fCbase/isremote.c\fP - that
the disam libary calls internally, and while this has no real advantage at
the moment, it is designed to allow the server binary more direct access
to the routines it will need in common with the disam library in order to
properly handle caching and other anticipated future enhancements.
.PP
For this reason disamnet must have \fCbase/isremote.c\fP visible in the include path,
but is otherwise compiled and linked as for any other disam utility.
.SH Service Administration
.PP
service administration is based on the \fIdisamnet\fP utility
.PP
.nf
\fC
  disamnet -lfdv -P(ort) -I(nterface)
     opts: l(isten) f(ork) d(aemon) v(erbose)
\fP
.fi
.PP
\fIdisamnet\fP with no arguments will read on \fCstdin\fP, and reply on \fCstdout\fP, and
as such should be compatible with all connection hosting and forwarding
agents that recognise this standard, including disam itself, which adopts
the same protocol internally.
.PP
option \fC-l\fP will listen for incoming TCP clients.
.PP
option \fC-I&lt;address&gt;\fP specifies the interface to listen on, default is all interfaces.
.PP
option \fC-P&lt;number&gt;\fP specifies the port, for default see \fCISNETPORT\fP define.
.PP
With option \fC-l\fP alone \fIdisamnet\fP will only serve one client at a time, and
all other clients will wait until the port is free - this may be used in
testing, or for deliberate load limiting in, for example, \(lqround robin\(rq
mitigation strategies, etc.
.PP
Option \fC-lf\fP runs a multi-client \(lqforking\(rq service, and is usually invoked
as \fC-lfd\fP, to make \fIdisamnet\fP run in the background automatically, in which
case it will also set \fIsignal(2)\fP \fCSA_NOCLDWAIT\fP and close the terminal file
handles.
.PP
Please note that (by default) \fC-f\fP is \(lqburst\(rq limited to one new client per
second, and that there are a finite number of slots in which to stack the
incoming connections, pending accept.  This may be adjusted or disabled via
the \fCBURST\fP defines at the top of \fCutil/disamnet.c\fP
.PP
Please note that lowercase options are non-standard in that they must all
be given at once, as in \fC-lfd\fP, and will not be recognised individually.
.PP
Please note that uppercase options expect a value without a following space,
as in \fC-I127.0.0.1\fP, and will not work otherwise.
.PP
\fIdisamnet\fP with listening option(s) and no further arguments will run as a
disam service, after first checking the endian token read from the client.
.PP
\fIdisamnet\fP may also be called with a command line following - taken as the
first word not starting with a dash - in which case it will operate as a
general pipe service that will listen for and connect clients to whatever
executable process is specified on the remaining command line.
.PP
examples:
.PP
.nf
\fC
  disamnet -lfd -P12300 -I127.0.0.1
\fP
.fi
.PP
This runs a complete multi-client service, which listens on ports 12300
and 12301, and is bound to the machine \(lqloopback\(rq interface only, and as
such will only respond to calls from clients on the same machine.
.PP
.nf
\fC
  disamnet -l /home/joe/my_debug_shell
\fP
.fi
.PP
This listens for a single client on the default port on all interfaces,
and calls the given file, which must be executable, and either given as a
fully qualified path, or found in server \fCPATH\fP environment.
.PP
/home/joe/my_debug_shell:
.PP
.nf
\fC
#!/bin/sh

# run test disamnet service with debugs turned on

ISDEBUG=/tmp /home/joe/my_disam_bin/disamnet
\fP
.fi
.SH Endian Order and Resolution
.PP
\fCutil/dswabnet.c\fP is a simple wrapper around \fCutil/disamnet.c\fP which defines
\fCISOTHERENDIAN\fP, which in turn produces a binary which will automatically
reorder the bytes in everything it knows to be an integer.
.PP
This includes all parameters and official structures, such as keydesc and
dictinfo, etc, but expressly does \fBnot\fP touch data records.  disamnet is
designed to compress and otherwise efficiently transmit data without loss,
but endian order in records is presumed to be handled on a higher level.
.PP
While it remains feasible to provide an automatic switching server, able
to handle either sort of client, should this be required, it is slightly
more efficient, after all considerations, to run a dual binary setup.
.PP
It is left up to the server administrator to decide which end is up, and
to assign a different port number to clients of each order, in order to
ensure that clients of the \(lqother\(rq order will connect to dswabnet, which
will translate for them, and clients of the same order as the server must
connect to disamnet, which does not.
.PP
Clients will return \fCENETORDER\fP error when connected to wrong ended servers.
.SH Application Considerations
.PP
ISAM files are stacked on common hosts, and only one connection per port
per host is allowed - meaning you can open any number of files across a
number of different servers, each of which will only be connected once,
if at all.
.PP
For TCP/IP hosts this is based on the IPv4 address after gethostbyname(3)
lookup, and as such should not be confused by aliases and mixed notation.
.PP
Pipe calls, like ssh, on the other hand, only pass on the address string
they are given, and this must therefore match exactly - case and all - or
will cause redundant extra connections and server processes.
.PP
Host connections are automatically closed when the last associated isam
file is closed, and will be reopened again, as needed.  If this should
result in too much overhead in your application, or otherwise causes any
trouble, please contact support - mitigation is probably a simple matter
of implementing an appropriate strategy - including disabling the feature
outright - depending on the situation.
.PP
isrename will return \fCEBADADDR\fP unless both names are on the same server.
.PP
iscopy will return \fCEBADADDR\fP unless both files on are on the same server.
.PP
If isclone is passed a network destination file name, and if the server on
which the source file is hosted can connect to the destination server, the
operation should work as expected.
.PP
The isCheck and ischeck series of functions will work over disamnet, and
the \fIdcheck\fP utility is able to check and rebuild remote files, but is not
able to display the additional header details normally shown.
.PP
Audit files are stored on the assocated isam file server.
.PP
DISAMNET is available through both the base and wrapper (cisam standard)
interfaces, but please note your application may no longer compile if you
have been using various internal fields within the disam file structure.
.PP
Please see the \fCIsamFile\fP structure in \fCisbase.h\fP for the changes, and
note that the bulk of this structure has been hidden behind \fCISDANGEROUS\fP.
.PP
These fields are only available in local files, and the entire structure
is different for remote files, from \fCISDANGEROUS\fP through to the end.
.PP
As long as the \fCisam->where\fP integer has a value of zero, the file is local,
and these fields are safe to access, but if there is any chance the file
might be remote, your application should check before proceeding.
.PP
The fields above \fCISDANGEROUS\fP are common to all sources, and are maintained
in sync with the source files on the remote server.


