.TH "API base reference" "7" "March 31" "disam_apibase" "Byte Designs DISAM"


.PP
The library provides two separate interface methods.
.PP
The \fIbase\fP
API uses allocated file descriptors (similar to the system fopen/fwrite calls) to
manage isam files, and it will be this interface that is described
here.
.PP
The \fIwrap\fP (CISAM\(tm standard) interface is covered here\&
.SM [1]
\&.
.br
\&
.SM [1]
\& disam_apiwrap.7.man
.br
.SH Primary Details
.PP
All modules which make core API calls should include \fCisbase.h\fP
.PP
In all of the following, isfd will be used to refer to an open isam
file descriptor, as returned by \fCisOpen\fP or \fCisBuild\fP, and declared as:
.PP
.nf
\fC
  struct IsamFile *isfd;          /* the formal way */
  IsFile *isfd;                   /* typedef shortcut */
\fP
.fi
.SH Return Values and Result Indicators
.PP
With the exception of \fCisBuild\fP, \fCisOpen\fP and a few others, the base will
return a boolean \fCISTRUE\fP or \fCISFALSE\fP.  \fCISTRUE\fP and \fCISFALSE\fP are defined
in the \fCisbase.h\fP header as 1 and 0 respectively.
.PP
When \fCISFALSE\fP is returned you will find the system or isam error code
in \fCisfd->iserrno\fP, where \fCisfd\fP is an open file descriptor.  ISAM error
codes start at 500 (refer to \fCISERRBASE\fP in [DISAM_INSTALL] if you need to
change this) and are listed under error codes below.   System error
codes have their usual values for the target system.
.PP
If \fCiserrno\fP is less than 500 (ie a system error) isErrio( \fCisfd\fP )
(or \fCisfd->iserrio\fP)
will provide a little more detail as to where and why, as shown under
[Error Codes] below.
.PP
Please note the original value for \fCISERRBASE\fP, while compatible with
CISAM, is no longer high enough to encompass all the normal system
errors, however if you are willing to deal with the confusion which
may result, there should be no other harm in re-setting \fCISERRBASE\fP to
the original value of 100.
.PP
In situations where no file descriptor is available, such as when
\fCisBuild\fP or \fCisOpen\fP fail, or after \fCisClose\fP, \fCisErase\fP or \fCisRename\fP, the
call will return the error code in the global errno variable.
.SH Machine Independent Data
.PP
The library includes the following series of calls to provide a means
of generating data that will be portable to different machines,
across the \fIendian divide\fP.
.PP
Use of these is only required if you need such portability, since
the library will accept native formats without complaint.
.PP
.nf
\fC
 int ldInt( char *pad );
 int stInt( int value, char *pad );
 long ldLong( char *pad );
 int stLong( long value, char *pad );
 int stChar( char *pad, char *str, int len );
 int ldChar( char *pad, int len, char *str );
 double ldFloat( char *pad );
 int stFloat( double value, char *pad );
 double ldDbl( char *pad );
 int stDbl( double value, char *pad );
 int stFltNull( double value, char *pad, short *null );
 double ldFltNull( char *pad, short *null );
 int stDblNull( double value, char *pad, short *null );
 double ldDblNull( char *pad, short *null );
\fP
.fi
.PP
In all of the above, \fCst\fP identifies calls that will place a value in
the specified location, which can then be retrieved by the matching
\fCld\fP call.
.PP
The Null suffix calls will load the variable passed (by address)
in the last parameter with a boolean \fCISTRUE\fP if the associated
value is zero, or \fCISFALSE\fP if not.
.PP
All pads referred to should be the size of the associated data type,
with the exception of \fCldInt\fP and \fCstInt\fP, which refer to a two byte integer,
regardless of the native word size, and \fCldLong\fP and \fCstLong\fP, which refer to
four bytes.
.PP
These (cisam derived) function names are based on old
world (16 bit native word size) realities, where \fCint\fP
was 2 bytes (short) and \fClong\fP meant 4.
.PP
The \fCFloat\fP and \fCDouble\fP calls do not perform any actual data
conversion, and are provided as a means of avoiding data alignment
problems only.
.PP
The \fCInt\fP and \fCLong\fP calls will perform byte order reversal
(sometimes referred to as swabbing) on platforms where the least
significant byte is found at the beginning of the field.
.PP
\fCldInt\fP and \fCstInt\fP operate on short (2 byte) integers,
although the value and return are passed as \fCint\fP, which ought to be
big enough in all models, including 16 bit.
.PP
Since the 64 bit model suddenly makes \fClong\fP
twice as big as will fit, \fCldLong\fP and \fCstLong\fP now operate on \fCint32_t\fP
as defined in \fCstdint.h\fP.  See Standard (C99) Integers\&
.SM [2]
\& for more.
.br
\&
.SM [2]
\& disam_stdint.7.man
.br
.SH ISAM indexes
.PP
ISAM indexes are defined/described by means of the \fCkeydesc\fP structure.
.PP
The following is an example of the basic procedure, and describes an
index that allows duplicates, has full compression, and consists of
two fields - a machine independent integer taken from the first two
bytes of the record, and a character string from the seventh through
sixteenth bytes.
.PP
.nf
\fC
 struct keydesc key;

 key.k_flags = ISDUPS+ISCOMPRESS;        /* see index flags */
 key.k_nparts = 2;                       /* number of fields involved */
 key.k_part[0].kp_start = 0;             /* offset in data record */
 key.k_part[0].kp_leng = INTSIZE;        /* length */
 key.k_part[0].kp_type = INTTYPE;        /* type */
 key.k_part[1].kp_start = 7;             /* offset in data record */
 key.k_part[1].kp_leng = 10 * CHARSIZE;  /* length */
 key.k_part[1].kp_type = CHARTYPE;       /* type */
\fP
.fi
.PP
This structure is then passed to \fCisBuild\fP, \fCisAddIndex\fP, \fCisStart\fP, etc.
.RS 3
.TP
\&Index flag values - these apply to the index as a whole
.TP
\&
.nf
\fC
  ISNODUPS     no duplicates permitted
  ISDUPS       duplicates permitted
  DCOMPRESS    compress duplicates
  LCOMPRESS    leading compression
  TCOMPRESS    trailing space compression
  COMPRESS     full compression
  TNULL        compress on zero instead of space in TCOMPRESS
\fP
.fi
.TP
\&Individual index component/part/field types
.TP
\&
.nf
\fC
  CHARTYPE     array of bytes/characters
  INTTYPE      two byte (short) integer
  LONGTYPE     four byte (long) integer
  DOUBLETYPE   ieee double floating point
  FLOATTYPE    ieee single floating point
  MINTTYPE     machine (native) short
  MLONGTYPE    machine (native) long
  STRINGTYPE   null terminated string
  ISDESC       add to any above for descending order
\fP
.fi
.RE
.PP
It is generally advisable to provide some callable means of loading
your key descriptions into a keydesc structure, or to provide some
other means of easy access, since they will be needed for selecting
indexes via isStart.
.PP
You will also need to exercise caution when using CHARTYPE fields
as the library does not recognise null terminated strings.
For example,
if you're referring to a 10 byte wide character field, and it
contains a seven byte string, a null terminator and 2 garbage bytes
following the null, the library will build a key 10 bytes in length
that includes the null and trailing garbage.  This key might prove
difficult to locate later.
.PP
The officially approved solution is to use the included stchar() and
ldchar() calls, which will pad the string passed with spaces on store
and replace the null terminator on load.
.PP
Note also that cisam standard trailing compression works on strings
of trailing spaces, so the common practice of terminating strings
with a zero (and optionally padding the remainder of the field with
zeros) will result in inefficient operation when trailing compression
is expected.
.PP
\fCSTRINGTYPE\fP has been added, to extend the standard, and this causes
terminated strings to be correctly indexed without extra padding.
.PP
\fCTNULL\fP has also been added, to trigger trailing compression on zero
values, rather than spaces.
.SH Open Modes
.PP
There are two different groups of open modes used by the \fCisOpen\fP and
\fCisBuild\fP calls.  The first group describes the operations which the
current process will be allowed to perform, while the latter controls
what forms of external access will be permitted.
.PP
Locking Method (mandatory)
.PP
.nf
\fC
  ISMANULOCK  record locks placed manually
  ISAUTOLOCK  record locks placed automatically on read
  ISEXCLLOCK  exclusive access to index and data
  ISRDONLY    read only - no locking
\fP
.fi
.PP
I/O Modes
.PP
.nf
\fC
  ISINPUT     open file for reading only (default)
  ISOUTPUT    open file for writing only
  ISINOUT     open file for both reading and writing
\fP
.fi
.PP
Variable Length - see Variable Length Records\&
.SM [3]
\&.
.br
\&
.SM [3]
\& disam_varlen.7.man
.br
.PP
.nf
\fC
  ISVARLEN    variable length records - see varlen.ref
  ISVARCMP    RLE compressed varlen data
  ISNOCARE    open either fixed or variable length
\fP
.fi
.PP
Transaction Processing - see Transaction Processing\&
.SM [4]
\&.
.br
\&
.SM [4]
\& disam_trans.7.man
.br
.PP
.nf
\fC
  ISTRANS     transaction processing
  ISNOLOG     disable logging
\fP
.fi
.PP
Other Options
.PP
.nf
\fC
  ISMASKED    index masking option - see Index Masking\&
.SM [5]
\&
  ISSYNCWR    all writes flushed to disk before return
\fP
.fi
.br
\&
.SM [5]
\& disam_mask.7.man
.br
.PP
Please note that ISSYNCWR is only active for systems that permit \fCO_SYNC\fP
in the file open call.  This precludes most DOS flavoured systems.
.SH Search Modes
.PP
all isRead operations act on the currently selected index.
.PP
.nf
\fC
  ISFIRST  select the first record in the index
  ISLAST   select the last record in the index
 
  ISEQUAL  search for and return the first exact match, or error
  ISGTEQ   search for first exact match, or next greater
  ISGREAT  search for the next greatest key in the index
 
  ISNEXT   skip to the next key in the index
  ISPREV   skip to the previous key in the index
 
  ISCURR   reread the current location.
\fP
.fi
.PP
\fCISNEXT\fP and \fCISPREV\fP behave differently when used in isRead
immediately after in isStart call in that they will return
the current rather than the next/previous record.
.PP
This is a feature, not a bug.  The intention is to allow
isStart to function as an initialisation call preceding
a read next/previous loop, as in the following:
.PP
.nf
\fC
  isStart( isfd, &secondary_index, 0, NULL, ISFIRST );
    while( isRead( isfd, data_pointer, ISNEXT ) )
      display_data( data_pointer );
\fP
.fi
.PP
The above will read the contents of isfd from the top in
secondary_index order.
.SH Lock Modes
.PP
These are added to the search mode in isRead to lock or wait for the
release of the selected record.
.PP
.nf
\fC
  ISLOCK   lock the selected record against external update
  ISWAIT   wait until the selected record has been released
  ISLCKW   wait for and unlock the selected record
\fP
.fi
.PP
\fCISLOCK\fP will return an \fCELOCKED\fP error if the selected record has been
locked, but will still return the selected record image.  this allows
the process to read an externally locked record, but warns that updates
will not be permitted.
.PP
\fCISWAIT\fP and \fCISLCKW\fP do no deadlock processing, and will wait forever, so
applications should be coded appropriately.
.PP
The isLock, isUnLock, isRelease, isRelRec and isRelCurr group of
functions provide further control over record locking, and you can
also use \fCISEXCLLOCK\fP to lock other processes out of a file completely.


