.TH "Error Codes" "7" "March 31" "disam_error" "Byte Designs DISAM"


.PP
In addition to the standard operating system error codes, the library
will return the following values in isfd->iserrno where appropriate:
.PP
.nf
\fC
  EDUPL     illegal duplicate
  ENOTOPEN  file not open
  EBADARG   illegal argument
  EBADKEY   illegal key description
  ETOOMANY  out of isam file handles
  EBADFILE  isam file is corrupt
  ENOTEXCL  can't get exclusive access
  ELOCKED   record is locked
  EKEXISTS  index already defined
  EPRIMKEY  illegal primary key operation
  EENDFILE  start or end file reached
  ENOREC    record not found
  ENOCURR   no current record
  EFLOCKED  file is locked
  EFNAME    file name is too long
  EBADMEM   can't allocate memory
  ENOPRIM   no primary key
  ELOGREAD  error reading log file
  EBADLOG   log file is corrupt
  ELOGOPEN  unable to open log
  ELOGWRIT  unable to write log
  ENOTRANS  transaction not found
  ENOBEGIN  no current transaction
  ENOPRIM   no primary key
  ENOLOG    logging not allowed
  EROWSIZE  varlen record too big
  EAUDIT    existing audit trail
  ENOLOCKS  out of room in lock table
  EEXPIRED  evaluation library has expired
  EREPAIR   auto repair in progress
  EBADADDR  bad network address
  ENOSCHEMA no schema defined
  EEXSCHEMA schema already defined
\fP
.fi
.PP
When the library returns a system error code it will also load
isfd->iserrio with the sum of the following two groups of values:
.PP
.nf
\fC
  IO_IDX   index file
  IO_DAT   data file

  IO_OPEN  while opening
  IO_CREA  while creating
  IO_SEEK  while seeking
  IO_READ  while reading
  IO_WRIT  while writing
  IO_LOCK  while locking
\fP
.fi
.PP
Please also see isErrno\&
.SM [1]
\& and isErrio\&
.SM [2]
\& for the recommended method of accessing these values.
.br
\&
.SM [1]
\& isErrno.3.man
.br
\&
.SM [2]
\& isErrio.3.man
.br


