.TH "isStart" "3" "March 31" "isStart" "Byte Designs DISAM"


.SH NAME
isStart \- select or relocate within an ISAM file index
.SH SYNOPSIS
.SS int isStart( IsFile * \fIisfd\fP, IsKdsc * \fIkdsc\fP, int \fIlen\fP, char * \fIdata\fP, int \fImode\fP );
\&
.TS
l l .
\fIisfd\fP 	 isam file descriptor 
\fIkdsc\fP 	 description of index to be selected or NULL to retain the current index 
\fIlen\fP 	 partial length of key, or 0 for full 
\fIdata\fP 	 data record pointer if needed for search mode, or NULL 
\fImode\fP 	 see search modes 
\&
.TE
.SH RETURN
.PP
ISTRUE, or ISFALSE,
in which case the error code is returned by
isErrno\&
.SM [1]
\&, or found in
isfd->iserrno\&
.SM [2]
\&
.br
\&
.SM [1]
\& isErrno.3.man
.br
\&
.SM [2]
\& disam_error.7.man
.br
.SH NOTES
.PP
this routine has multiple purposes.
.PP
if kdsc is passed then the index described will become current.
.PP
if length is non zero then
isStart
will set a partial key
length for the selected index, and will only consider the
first len bytes of the key during subsequent searches. this
will remain in effect until the next
isStart
call.
.PP
the selected location in the index will be flagged as a start
point, which means that the next call to isRead, if made with
a search mode of \fIISNEXT\fP or \fIISPREV\fP, will return the current
record, rather than the actual next or previous. this is often
useful for initialising next or previous read loops.
.PP
after a successful
isStart
call,
isfd->isrecnum
will be set to the current record number.


