.TH "Regression Test Source" "7" "March 31" "disam_test" "Byte Designs DISAM"


.SH Introduction
.PP
The test directory contains some stand-alone executables which you
may find useful for reliability or performance testing, or as a
sample of the standard wrapper interface usage.
.SH Tests
.PP
Most of these depend on \fCbench.h\fP and \fCbench.c\fP in the same directory.
.SS auto.c
.PP
Essentially a loose collection of calls that will build,
add and delete indexes, write, read and delete pseudo
random data records, and check the results.  useful for
testing the integrity of your compiled library.  the
standard auto run is 500 records, but this can be
changed by specifying a different count on the command
line.
.SS bash.c
.PP
Cycles and recycles a fixed series of progressively less
complex keys in order to fully test duplicates in as many
dimensions as possible.
.SS life.c
.PP
Simple multi-user simulation based on a closed economy.
Economy is a given number of core units and a given amount of liquid goop.
Goop is added to unit cores to begin a shop life equal to core plus goop.
Shop life decays until zero, at which point unit is moved to the dump.
Units may be recycled from the dump, and earn goop when stacked on core file.
Enough to begin with for now, works as advertised, useful for testing multi-user
locking and transaction concurrency, under scalably heavy loads.
.SS lock.c
.PP
Test record locking - will build and populate a sample
data file (if not found in current directory) and then
loop through the data, locking a sequential subset of
the records.
.SS mult.c
.PP
Cyclic add/update/delete test intended for checking the
index locking and multi-user features.
.SS user.c
.PP
An undocumented and simplistic command line interactive            
test engine used to verify specific operations.  It is a
long way from complete, but might prove useful if you are
able to figure it out.  The support department may ask you
to run it as a means of checking that your compiled library
is operating correctly.
.SH Notes
.PP
\fCuser\fP now includes the ability to make system calls (sys)
and can run simple scripts (run).
\fCauto\fP and \fCmult\fP will use varlen data if \fC-v\fP is passed on the command
line, and will add compression to same if \fC-vc\fP is used.


