.TH "Installation manual" "7" "March 31" "disam_install" "Byte Designs DISAM"


.SH Installation
.PP
The library is split into two sections - the base and the wrapper.
.PP
The base source is found in the base subdirectory, and the wrapper
source in wrap.  All public header files are in the head directory.
.PP
API References
.RS 4
.IP 1. 4
\&API base reference\&
.SM [1]
\&
.IP 2. 4
\&API wrap reference\&
.SM [2]
\&
.br
\&
.SM [1]
\& disam_apibase.7.man
.br
\&
.SM [2]
\& disam_apiwrap.7.man
.br
.RE
.PP
If you plan to use only the base library then you can ignore both
the wrap directory and \fChead/iswrap.h\fP
.PP
If you are planning to use only the wrapped (cisam\(tm standard) calls
then you should probably compile everything into one library and
ignore \fChead/isbase.h\fP entirely.
.PP
If you intend to use both flavours, then it might be an idea to
build two separate libraries, but this is optional.
.PP
Note that if you plan to use the wrapper calls, or the transaction
processing module, the base library MUST be compiled with \fCISADMIN\fP
activated.
.PP
Before starting you will need to edit \fCisconfig.h\fP and adjust it as
appropriate - refer to Configuration below for details.
.RS 3
.TP
\&NOTE
.RE
.PP
Some compilers produce unsigned char types as the default.
this must be changed - at least when compiling the base and
wrapper modules - all char types must default to signed.
this inconvenience will be corrected in future releases.
.PP
The source for the \fCdcheck\fP utility is located in the \fCutil\fP directory
and should be linked with the base library to produce an executable.
Documentation is found in dcheck\&
.SM [3]
\&.  The same is
true for the dpack\&
.SM [4]
\& and dlist\&
.SM [5]
\& utilities.
.br
\&
.SM [3]
\& dcheck.1.man
.br
\&
.SM [4]
\& dpack.1.man
.br
\&
.SM [5]
\& dlist.1.man
.br
.PP
The \fCtest\fP directory contains a collection of benchmark utilities,
documented in Regression Test Source\&
.SM [6]
\&
.br
\&
.SM [6]
\& disam_test.7.man
.br
.PP
You will find a makefile in the root folder - this is configured to
match the source folders as distributed, and will make all targets
from the current directory, placing the result in the target folder.
.PP
To compile and check disam \(lqout of the box\(rq, run:
.PP
.nf
\fC
make clean new lib util test check
\fP
.fi
.PP
in your disam source folder.
.SH Configuration
.SS ISADMIN
.PP
.nf
\fC
#define ISADMIN     1                   /* global file administration */
\fP
.fi
.PP
With this option active, the library will maintain an internal table
of active isam file descriptors, reuse system file handles when more
than one instance of the same isam file is opened, and include the
isCleanUp\&
.SM [7]
\& call amongst the library entry points.  Admin is mandatory
when the standard wrapper library or transaction processing are used,
and definitely advisable if you plan to open more than one instance
of the same file at any given time.
.br
\&
.SM [7]
\& isCleanUp.3.man
.br
.SS ISAUDIT
.PP
.nf
\fC
#define ISAUDIT     1                   /* 0:off 1:active */
\fP
.fi
.PP
A value of one includes support for cisam standard audit trail
logging, see Audit Trail Mechanism\&
.SM [8]
\& for details.
.br
\&
.SM [8]
\& disam_audit.7.man
.br
.SS ISLOGGING
.PP
.nf
\fC
#define ISLOGGING   1                   /* 0:none 1:standard */
\fP
.fi
.PP
A value of one includes support for cisam standard transaction
logging and processing, together with a number of enhancements.
see Transaction Processing\&
.SM [9]
\& for more details.
.br
\&
.SM [9]
\& disam_trans.7.man
.br
.PP
NOTE - to use this option you must activate the ISADMIN feature.
.PP
NOTE also that transaction processing is currently supported under threads.
.SS ISVARIABLE
.PP
.nf
\fC
#define ISVARIABLE  0            /* 0:none 1:cisam 2:disam 3:huge*/
\fP
.fi
.PP
A value of one includes support for variable length records in the
standard cisam compatible configuration.
.PP
A value of two provides
a better hash table algorithm and finer granularity with regard to
the use and reuse of slots in the variable length data storage nodes.
both one and two include support for data compression.
.PP
A value of three adds the ability to store up to 4294967295 records.
.PP
There is a limitation in the original disam/cisam variable length
in that the maximum record number that can be stored in the 3 bytes
allocated for storing varinfo and continuation node record numbers is
16777216.  A value of three removes this limit.
.PP
Please see Variable Length Records\&
.SM [10]
\& for more details.
.br
\&
.SM [10]
\& disam_varlen.7.man
.br
.SS ISLOCKING
.PP
.nf
\fC
#define ISLOCKING   2                  /* 0:none 1:old 2:new 3:lck */
\fP
.fi
.PP
A value of zero will disable locking entirely, resulting in a faster
and lighter version of the library, suitable for single user use, or
where all media is read only, etc.
.PP
Locking one enables the original cisam (prior to version 4) locking algorithm.
.PP
Locking two is the current (standard) method used by cisam versions
4 and greater, and may also be faster on some platforms.
.PP
Locking three is compatible with the DOS 'third file' locking method,
and is provided to allow 'lowest common denominator' NFS concurrency
with dos based applications.
.PP
Locking one and three rely on the lockf() system call, two requires fcntl().
.SS ISDUPLOCKS
.PP
.nf
\fC
#define ISDUPLOCKS  1                   /* honour locks in dup opens */
\fP
.fi
.PP
Cisam allows the same file to be opened more than once in EXCLLOCK
mode within the same process.  It also permits the same record to
be locked more than one under different filehandles within the same
process, not to mention that it is also legal to erase a file that
is already open in the current process, after which point any data
written to the file will evaporate.  Set this to zero for cisam
compatible operation, but please be careful..
.SS ISDECLARE
.PP
.nf
\fC
#define ISDECLARE   1                   /* include prototypes */
\fP
.fi
.PP
If non zero then full \fCANSI\fP standard function prototyping is enabled.
.PP
ISDATAVOID
.nf
\fC
#define ISDATAVOID  0                   /* void data pointers */
\fP
.fi
.PP
Cisam insists that all record pointers passed must be \fCchar\fP type.
if \fCISDATAVOID\fP is set to one, they will be declared as type \fCvoid\fP
which, under some compilers, will allow you to pass anything without
warnings.  This feature is compiler dependent.
.SS ISCUSTOM
.PP
.nf
\fC
#define ISCUSTOM  0                     /* custom key types */
\fP
.fi
.PP
This option allows the addition of custom key types - refer to
Custom Key Types\&
.SM [11]
\& for more details.
.br
\&
.SM [11]
\& disam_custom.7.man
.br
.SS ISBERKELY
.PP
.nf
\fC
#define ISBERKELY 0                        /* 0:memcpy() 1:bcopy() */
\fP
.fi
.PP
A value of one uses the berkely memory handling functions bcopy()
and bcmp() and covers for the absence of memset() internally.  a
value of zero uses the default memcpy(), memcmp() and memset()
calls.
.SS ISLONGID
.PP
.nf
\fC
#define ISLONGID  0                     /* allows for long pids */
\fP
.fi
.PP
A value of 1 will override the C-ISAM / X/OPEN spec that forces
short integer values to be stored in the transaction processing 
logfile and audit trail file for pids and uids.
.PP
** WARNING ** do not set to 1 if you are expecting C-ISAM/X/OPEN
concurrency or file compatibility or if the process ids returned
from the system's getpid() function are short values.
.SS ISIDXBLK
.PP
.nf
\fC
#define ISIDXBLK    1024                /* default index block size */
\fP
.fi
.PP
The default index block size to be used when creating isam files.
512 and 1024 are the usual standards.  512 is compatible with older
versions of cisam, while 1024 seems to be most common value, and
is compatible with current cisam files.  1024 will be enforced when
building variable length files, but you can still use other values
for your regular data.
.SS ISDUPLEN
.PP
.nf
\fC
#define ISDUPLEN    4                   /* default duplicate width */
\fP
.fi
.PP
The width of the field used to store the duplicate sequence numbers
in the index.  A value of 4 will permit approximately 2000 million
identical keys in any given index, while 2 imposes a limit of just
over 32500.  4 is more expensive in terms of disk space, so you may
wish to consider using 2 if this is important and you not intend to
go over the limit.  Bear in mind that the limit applies to the max
count of an individual identical key, not to the total number of
duplicates in the index.  4 is compatible with current cisam, 2
with older versions.
.SS ISMAXPATH
.PP
.nf
\fC
#define ISMAXPATH   1024                /* maximum path len */
\fP
.fi
.PP
The amount of space to allocate and enforce when working on paths.
.SS ISMAXIDX
.SS ISMAXPARTS
.SS ISMAXKEY
.PP
.nf
\fC
#define ISMAXIDX    10                  /* indexes per file */
#define ISMAXPARTS  10                  /* parts per key */
#define ISMAXKEY    128                 /* bytes per key */
\fP
.fi
.PP
These set the number of indexes per file, the number of parts per index,
and the total allowable byte count per index key.  The value of \fCISMAXPARTS\fP
is also available via the standard \fCNPARTS\fP define.
.SS ISMAXBUF
.PP
.nf
\fC
#define ISMAXBUF    20                  /* buffers per index */
\fP
.fi
.PP
This is actually a slight misnomer in that the root node is always
buffered, so the resultant number of memory allocations will actually
be one more than the number you specify here.  One important caveat
applies - you must specify a value that is at least twice the expected
depth of the largest expected index tree.
.SS ISERRBASE
.PP
.nf
\fC
#define ISERRBASE   500                 /* start error codes at */
\fP
.fi
.PP
The library generated iserrno values traditionally start at 100.  On
most newer platforms this conflicts with system generated errno values.
You can use this define to change where the DISAM error codes start.
.SS ISTHREADED
.PP
.nf
\fC
#define ISTHREADED 0                        /* threadsafe handling */
\fP
.fi
.PP
Please refer the Thread Safety\&
.SM [12]
\& for details.
.br
\&
.SM [12]
\& disam_thread.7.man
.br
.SS ISPURE
.PP
.nf
\fC
#define ISPURE 0                        /* sequential pure indexes */
\fP
.fi
.PP
Set ISPURE to 1 to insert a call to store a sequential value for isrecnum
in all pure indexes\&
.SM [13]
\&.
.br
\&
.SM [13]
\& disam_pure.7.man
.br


