.TH "isCluster" "3" "March 31" "isCluster" "Byte Designs DISAM"


.SH NAME
isCluster \- rebuild an ISAM file in a given natural order
.SH SYNOPSIS
.SS IsFile *isCluster( IsFile * \fIisfd\fP, IsKdsc * \fIkey\fP );
\&
.TS
l l .
\fIisfd\fP 	 isam file descriptor 
\fIkey\fP 	 description of index to cluster on 
\&
.TE
.SH RETURN
.PP
ISTRUE, or ISFALSE,
in which case the error code is returned by
isErrno\&
.SM [1]
\&, or found in
isfd->iserrno\&
.SM [2]
\&
.br
\&
.SM [1]
\& isErrno.3.man
.br
\&
.SM [2]
\& disam_error.7.man
.br
.SH NOTES
.PP
the file must be open in exclusive mode
.PP
this routine makes use of a temporary file, created in the
same directory as the original.
.PP
all active data records will be transferred to the temp file
in the index order specified, and all indexes will be packed
as efficiently as possible.
.PP
if successful,
isCluster
will return a new file descriptor,
opened in the same format as the original, which will be
abandoned. a NULL pointer will be returned on error, and
the original descriptor and file will be left intact.
.PP
be warned that this call may take some time to run if the
file in question is large.


