.TH "Transaction Processing" "7" "March 31" "disam_trans" "Byte Designs DISAM"


.SH Introduction
.PP
We have attempted to provide a transparent implementation of the
transaction processing routines provided by cisam\(tm.  The library
should perform as specified in the cisam manuals, but also includes
a few additional enhancements.
.PP
We are not certain that we have identified the log file locking offsets
properly.  There is a possibility that the library will not co-operate
in concert with cisam, but we have not found any problems to date.
.PP
Transaction Processing is activated via \fCISLOGGING\fP in isconfig.h\&
.SM [1]
\&
.br
\&
.SM [1]
\& disam_install.7.man
.br
.RS 3
.TP
\&NOTE
.RE
.PP
The overlapping transactions option has been modified, \fCissusplog\fP
and \fCisresumlog\fP are discontinued - see Overlapping Transactions
for more details.
.RS 3
.TP
\&NOTE
.RE
.PP
Please ignore any references to multi-thread support in the
following - we have currently abandoned the attempt to supply
such support due to lack of interest.  Please let us know\&
.SM [2]
\& if
this is a problem to you, although please understand that this
is not a trivial issue to resolve.  It is difficult enough to
keep reliable track of serial transactions, as it is..
.br
\&
.SM [2]
\& disam_support.7.man
.br
.SH Function Calls Reference
.SS isLogOpen
.PP
.nf
\fC
  int isLogOpen( char * name )
  int islogopen( char * name )
\fP
.fi
.PP
Opens log file.  Once the log file is opened all subsequent operations
on all files will be logged until the log is closed or suspended.  Each
process is responsible for opening a log file.  Usually all processes
within an application will open the same log file.  Access is governed
by concurrency locks to prevent simultaneous writes, but this feature
might not be compatible with cisam.  Files opened/built with \fCISNOLOG\fP
in the mode will not be logged.
.SS isLogClose
.PP
.nf
\fC
  int isLogClose( void );
  int islogclose( void );
\fP
.fi
.PP
Closes log file for the process.  All subsequent operations will not
be logged.
.SS isBegin
.PP
.nf
\fC
  int isBegin( void );
  int isbegin( void );
\fP
.fi
.PP
Defines the beginning of a set of operations on all files opened with
ISTRANS in the mode argument.  This set of operations is known as a
transaction.
.PP
All records updated within the transaction will remain locked to ensure
no other process can affect the results.  In multi-user situations it
is important to keep the time spent within a transaction to a minimum
to avoid impacting on other processes' access to the records involved.
.PP
All calls to isclose within the transaction will be deferred to avoid
releasing the locks mentioned above.  If the same file is reopened
within the same transaction you will simply get the same file handle
back.
.PP
All updates affect the data file immediately.  If the process should
terminate before completing the transaction, the changes will remain
unless isrecover is used to rebuild the data from the last backup.
.SS isCommit
.PP
.nf
\fC
  int isCommit( void )
  int iscommit( void )
\fP
.fi
.PP
Defines the successful completion of a transaction.  All locked
records will be released and all deferred closes honoured.
.SS isRollBack
.PP
.nf
\fC
  int isRollBack( void )
  int isrollback( void )
\fP
.fi
.PP
Defines the unsuccessful completion of a transaction.  All updated
records will be restored to their original state, all record locks
released and all deferred closes honoured.
.SS isRecover
.PP
.nf
\fC
  int isRecover( void )
  int isrecover( void )
\fP
.fi
.PP
Called to rebuild a set of data files from an original condition by
means of a common log file.  islogopen() must be called first to
open the log.
.RS 3
.TP
\&NOTE
.RE
.PP
isrecover is NOT threadsafe and should only be used under
single threaded circumstances, or at very least only when
there are no other threads working on isam files.
.SH Data File Recovery
.PP
If, at the time a full data backup was made, the transaction log
was purged, then, provided all updating processes call islogopen()
before making changes, it is possible to rebuild the data files
from the backup and the log file.
.PP
It is not necessary that files be opened with a mode of ISTRANS
for changes to be logged.  Once the log is open, all subsequent
ISAM opens will automatically be logged, and only Files that are
opened with a mode of ISNOLOG will not be logged.
.PP
To recover files it is necessary to compile a recovery utility
that will call the following functions in order:
.PP
.nf
\fC
  islogopen( "logname" );
  isrecover();
  islogclose();
\fP
.fi
.PP
The recovery procedure will then be to restore the backup (make
sure not to overwrite the log file) and run the recovery utility.
The utility should check the return from isrecover() to ensure no
errors occurred during recovery.
.PP
It is also possible to implement incremental backups by this
method.  The log file can be backed up and purged on a regular
basis.  To recover it will be necessary to restore the original
backup, then restore and run the recovery utility on each log
file in chronological order.
.SH Transaction Processing Fundamentals
.PP
The theory behind transaction processing is that a collection of
changes to a group of data files can be defined in such a way as
to be able to undo these changes at any time during the operation.
.PP
The collection of changes is referred to as a transaction.
.PP
A sample program might best serve to illustrate.  Proper error
checking has been omitted to simplify:
.PP
.nf
\fC
/* post a sales invoice */

#include <iswrap.h>

int invcFile;   /* source invoice record file */
int custFile;   /* customer master records */
int tranFile;   /* accounting transaction file */

main()
  {
  islogopen( "logfile" );

  invcFile = isopen( "invoice",     INOUT + ISTRANS );
  custFile = isopen( "customer",    INOUT + ISTRANS );
  tranFile = isopen( "transaction", INOUT + ISTRANS );

  isstart( invcFile, ..., ISFIRST );

  /* loop through invoices */
  while( isread( invcFile, invcrec, ISNEXT ) == SUCCESS )
    {
    isbegin();                  /* define transaction start */

    if(
      postCust() == SUCCESS     /* update customer master */
      &&
      postTran() == SUCCESS     /* create transaction record */
      &&
      delInvc() == SUCCESS      /* delete invoice record */
      )
      iscommit();               /* successful, commit changes */
    else
      isrollback();             /* failed, erase changes */
    }

  isclose( invcFile );
  isclose( custFile );
  isclose( tranFile );

  islogclose();

  exit( 0 );
  }
\fP
.fi
.PP
Note that the transaction processing logic will lock all records
that are changed within the transaction for the duration of the
transaction.  In some instances it pays to keep the transaction
cycle as short as possible to allow other processes access to
these records.
.PP
Note also that those files whose changes are to be erased when
isrollback is called must be opened with mode ISTRANS.  changes
will still be logged for those that are not, but the transaction
processing logic ignores them and will not undo any changes.
.SH Overlapping Transactions
.PP
As an extension to the cisam standard, and also as a means of
allowing flexible use of transaction processing within multi-
threaded applications, the library provides a mechanism for
handling multiple concurrent (or overlapping) transactions.
.PP
Management centers around the use of a callback function provided
by the application.  In order to permit overlapping transactions
you must first call isTxnInit( callback ), where callback is the
name of a routine that will return a short integer value that the
library will use to determine which operations belong to which
transaction.
.PP
In a single threaded application the simplest method is to declare
a variable that is visible to all routines that handle transactions
and to the callback function itself.
.PP
For example, assuming a simple nested transaction operation:
.PP
.nf
\fC
    static short txnid;

    txnid = 1;
    isbegin();
    for( account = 0; account < 5; ++account )
      {
      /* update account master files */
      txnid = 2;
      isbegin();
      /* update account files */
      iscommit() or isrollback();
      txnid = 1;
      }
    iscommit() or isrollback();
\fP
.fi
.PP
In a multi-threaded application, assuming the intention is to
allow atomic transactions within individual threads, you would
have the callback routine return the thread id value.


