.TH "Variable Length Records" "7" "March 31" "disam_varlen" "Byte Designs DISAM"


.SH Introduction
.PP
Please refer to Installation manual\&
.SM [1]
\& for activation and configuration details.
.br
\&
.SM [1]
\& disam_install.7.man
.br
.PP
The following provides a list of the functional and programmatic differences
between fixed length and variable length isam file handling.
.PP
If you are using the base\&
.SM [2]
\& interface then
isReclen\&
.SM [3]
\&( \fCisfd\fP ) is used to read the current record length, and
isSetlen\&
.SM [4]
\&( \fCisfd\fP, \fClen\fP ) is called to set it.
.br
\&
.SM [2]
\& disam_apibase.7.man
.br
\&
.SM [3]
\& isReclen.3.man
.br
\&
.SM [4]
\& isSetlen.3.man
.br
.PP
You can also read and write \fCisfd->isreclen\fP directly.
.PP
If you are using the wrap\&
.SM [5]
\& interface then
\fCisreclen\fP is a global integer used to pass variable length info around
in much the same way as isrecnum.
.br
\&
.SM [5]
\& disam_apiwrap.7.man
.br
.SH Functional Details
.PP
isAddIndex\&
.SM [6]
\&
.br
isaddindex\&
.SM [7]
\&
.br
.RS 8
The parts of any key added must reside within the fixed length part
of the record.
.br
\&
.SM [6]
\& isAddIndex.3.man
.br
\&
.SM [7]
\& isaddindex.3.man
.br
.RE
.PP
isBuild\&
.SM [8]
\&
.br
isbuild\&
.SM [9]
\&
.br
.RS 8
You can add \fCISVARLEN\fP to the mode argument to create a varlen file,
in which case the record length argument must define the maximum
possible length of the records.
.br
\&
.SM [8]
\& isBuild.3.man
.br
\&
.SM [9]
\& isbuild.3.man
.br
.PP
In the wrap\&
.SM [10]
\& API you must set \fCisreclen\fP to the
size of the fixed length header portion of the record.
.br
\&
.SM [10]
\& disam_apiwrap.7.man
.br
.PP
Key fields can only reside in the fixed length portion.
.PP
You can also use ISVARCMP in place of ISVARLEN to specify that RLE
compression be applied to the data.
.RE
.PP
isvbuild\&
.SM [11]
\&
.br
.RS 8
\fCisvbuild\fP should be used in place of isbuild if you are creating
variable length files in a multithreaded\&
.SM [12]
\& environment.
.br
\&
.SM [11]
\& isvbuild.3.man
.br
\&
.SM [12]
\& disam_thread.7.man
.br
.RE
.PP
isIndexInfo\&
.SM [13]
\&
.br
isindexinfo\&
.SM [14]
\&
.br
.RS 8
If file is variable, the msb of \fCdi_nkeys\fP will be set to indicate same.
\fCdi_recsize\fP contains the maximum record size, the fixed length size is
returned in \fCisreclen\fP.
.br
\&
.SM [13]
\& isIndexInfo.3.man
.br
\&
.SM [14]
\& isindexinfo.3.man
.br
.RE
.PP
isOpen\&
.SM [15]
\&
.br
isopen\&
.SM [16]
\&
.br
.RS 8
If the file is variable length you must use \fCISVARLEN\fP in the mode, or
else \fCisOpen\fP will return an \fCEBADARG\fP error.  The inverse is also true -
if the file is not variable length, then specifying \fCISVARLEN\fP will
return the same error.  If successful then isreclen will be set to the
maximum record length of the opened file.
.br
\&
.SM [15]
\& isOpen.3.man
.br
\&
.SM [16]
\& isopen.3.man
.br
.PP
To get around the inconvenience of the above, you can use \fCISNOCARE\fP
in the open mode, in which case the file will be opened regardless
of whether it is variable or fixed length.  You can then check the
open mode value to determine which kind of file was opened.  This
is found in \fCisam->openmode\fP if you are using the core (base) library calls,
or loaded by means of \fCisgetmode( int isfd, int *mode )\fP if using
the classic (wrapper) library.
.RE
.PP
isRead\&
.SM [17]
\&
.br
isread\&
.SM [18]
\&
.br
.RS 8
\fCisreclen\fP will be set to the actual size of the record just read.
.br
\&
.SM [17]
\& isRead.3.man
.br
\&
.SM [18]
\& isread.3.man
.br
.RE
.PP
isRewCurr\&
.SM [19]
\&, isRewRec\&
.SM [20]
\&, isRewrite\&
.SM [21]
\&, isWrCurr\&
.SM [22]
\&, isWrite\&
.SM [23]
\&
.br
isrewcurr\&
.SM [24]
\&, isrewrec\&
.SM [25]
\&, isrewrite\&
.SM [26]
\&, iswrcurr\&
.SM [27]
\&, iswrite\&
.SM [28]
\&
.br
.RS 8
These all expect \fCisreclen\fP to be set to to the actual size of the
record, before calling.
.br
\&
.SM [19]
\& isRewCurr.3.man
.br
\&
.SM [20]
\& isRewRec.3.man
.br
\&
.SM [21]
\& isRewrite.3.man
.br
\&
.SM [22]
\& isWrCurr.3.man
.br
\&
.SM [23]
\& isWrite.3.man
.br
\&
.SM [24]
\& isrewcurr.3.man
.br
\&
.SM [25]
\& isrewrec.3.man
.br
\&
.SM [26]
\& isrewrite.3.man
.br
\&
.SM [27]
\& iswrcurr.3.man
.br
\&
.SM [28]
\& iswrite.3.man
.br
.RE
.PP
isCheckVarlen\&
.SM [29]
\&
.br
ischeckvarlen\&
.SM [30]
\&
.br
.RS 8
This will check the integrity of the varlen storage in an ISAM index.
.br
\&
.SM [29]
\& isCheckVarlen.3.man
.br
\&
.SM [30]
\& ischeckvarlen.3.man
.br
.RE
.SH Compression
.PP
The library provides optional RLE compression on the variable length
portion of the data record.  This is specified when creating the file
by using a mode flag of \fCISVARCMP\fP in place of \fCISVARLEN\fP.
.PP
Please note that \fCISVARCMP\fP and \fCISVARLEN\fP are \fBNOT\fP additive - you must use one or the
other, not both.
.PP
Once a compressed varlen file has been created, you can use either
\fCISVARLEN\fP or \fCISVARCMP\fP when opening the file - either will work, and
the file will be opened in the appropriate mode.
.PP
Please note that RLE encoding is only valuable if your data has a fair
distribution of repeated zero (0), decimal zero (48), or space (32)
bytes.
.PP
Compression is transparent to the application - records are written
and read as before.
.PP
Compression is a Byte Designs feature, and is not cisam\(tm compatible.
.SH Notes
.PP
The check utility\&
.SM [31]
\& will analyse and test the variable length storage
nodes and report statistics.
.br
\&
.SM [31]
\& dcheck.1.man
.br


