.TH "Audit Trail Mechanism" "7" "March 31" "disam_audit" "Byte Designs DISAM"


.SH Configuration
.PP
ISAUDIT settings in isconfig.h
.PP
.nf
\fC
   0 - no audit functionality
   1 - audit writes, updates and deletes
   2 - audit writes only
   3 - audit deletes only
   4 - audit updates only
   5 - audit writes and deletes
   6 - audit writes and updates
   7 - audit deletes and updates
\fP
.fi
.SH Installation
.PP
Audit trail support is activated by setting ISAUDIT to a value of 1
in isconfig.h before compiling the library.
.SH Function Reference
.PP
int isAudit\&
.SM [1]
\&( IsFile * \fIisfd\fP, char * \fIpad\fP, int \fImode\fP );
.br
\&
.SM [1]
\& isAudit.3.man
.br
.SH Notes and Caveats
.PP
The audit trail is essentially a more streamlined alternative to the
full featured transaction processing option.  Only updates to the file
are tracked, and the processing overhead is less.  While there is no
harm in having both options active in your library at the same time,
it would be somewhat redundant to have both in use on the same file.
.PP
Two things to be aware of:
.PP
The audit trail impacts the overall efficiency of the library - if
you do not plan to use it, you would probably be best advised to leave
it inactive.
.PP
Once a file has been designated as having an audit trail, and even if
the trail is currently in the inactive state (AUDSTOP'ed), updates to
the file will be slower because, by cisam\(tm design, the protocol
requires that the status be checked each time the file
is updated by another process.  This is only the case when the file is
open by multiple processes.
.PP
This information presented mostly for reference - the actual impact
is reportedly quite minimal under all platforms tested.
.SH Audit Trail Format
.PP
The format of the audit trail consists of a header record followed by
a data image, repeated sequentially.  In the case of variable length
files, an additional 2 bytes are included to give the record length.
all values are stored in machine independent (ldint/ldlong) format.
.PP
.nf
\fC
struct audhead                          /* audit record header format */
  {
  char au_type[2];                      /* record type (aa/dd/rr/ww) */
  char au_time[4];                      /* date and time */
  char au_procid[2];                    /* process id */
  char au_userid[2];                    /* user id */
  char au_recnum[4];                    /* record number */
  char au_reclen[2];                    /* record length if variable */
  };

#define AUDHEADSIZE     14              /* audit header length */
#define VAUDHEADSIZE    16              /* if variable length */
\fP
.fi
.PP
type codes are translated as follows:
.PP
.nf
\fC
aa - record added to file
dd - record deleted from file
rr - record image before rewriting
ww - record image after rewriting
\fP
.fi


