.TH "Design Concepts and Rationale" "7" "March 31" "disam_design" "Byte Designs DISAM"


.SH Introduction
.PP
In order to facilitate thread safe programming, the core library has
been developed to use isam file descriptor structures, rather than
the standard integral handle concept.  The external function calls
are named after the original function names, but use capital letters
to keep them separate, as in isOpen rather than isopen.  the status
and information globals, such is iserrno and iserrio, have been
eliminated, and each file descriptor now carries it's own copy. 
.PP
The standard (lower case) calls are provided as an optional wrapper
layer which maintains a dictionary of descriptors to allow mapping
via the standard integer file handles.  It also defines and passes
the standard global variables.
.SH Conventions
.PP
All public library function names start with 'is' and use capital
letters to distinguish keywords.
.PP
All structure definitions and typedefs start with a capital letter,
and use the same capitalisation rules to distinguish keywords, with
the exception of standard integers\&
.SM [1]
\&.
.br
\&
.SM [1]
\& disam_stdint.7.man
.br
.PP
The posix standard system calls are wrapped in functions prefixed
by is and an underscore.
.PP
Local support routines in each module are named in lowercase.
.PP
Macro definitions are all capitals.
.PP
Virtually all entry and internal functions return \fCTRUE\fP on success
and \fCFALSE\fP on failure.  \fCTRUE\fP is defined as 1, \fCFALSE\fP is 0.
.SH Buffering
.PP
The tree node buffering system operates by handing node images which
are no longer part of the current path to a storage mechanism.  Each
index carries it's own path list and storage array.
.PP
A single linked list holds the current path and facilitates traversal
without having to move data around.  The node description structures,
which contain current status information and a copy of the node disk
image, are are passed to and from the path list and the buffer array
as pointers.
.PP
The buffer cache is currently optimised on a last in first out basis.
it might be worthwhile to consider optimising this further by giving
a degree of precedence to nodes from lower levels in the tree, on the
assumption that these will take more hits.
.PP
Buffers are flagged invalid whenever the index file header transaction
count has been changed by another process, and will be refreshed as
required.
.PP
At some point in the future, at the cost of cisam concurrency, it may
be worthwhile to consider designing a more detailed currency control
which would maintain separate transaction counts for each index, and
perhaps additional counts for the index and data free lists, variable
length storage space, and so on.
.PP
The same buffering system provides a failsafe error recovery method
in which updated node images are flagged invalid on error, which then
results in a forced refresh before the image can be used again.  this
method allows for optimistic updates, eliminating the need to check
first before embarking on potentially illegal updates.  see error
handling below for more details.
.SH Uncompressed Versus Compressed Indexes
.PP
For the dual purpose of keeping the code cleaner and to improve
performance, the index handling routines are split into separate
functions where the associated handling is markedly different.
.PP
Flat indexes, in general, can be operated on mathematically, lend
themselves to shell searches, and permit the current key value to
be a simple pointer into the node image.
.PP
Compressed indexes require that each node be searched in a linear
fashion, building the key image in an allocated buffer en route,
and generally require a fair amount more processing to operate.
.PP
The index handing and manipulation modules - isnode, isgrow and
isprune - all adhere to this standard.  The decision as to which
handling method to apply is made at the top level, eliminating the
need for myriad if-then-else tests during processing.
.SH Error Handling
.PP
The new library deals with errors via ''setjmp''/''longjmp''.  Each external
entry point is responsible for initialising a jump buffer and mode
flag in the file descriptor.  When an error is detected the thread
is passed to an error handling routine which sets the error codes
and drops the index locks before returning control the entry call.
.PP
The error handling routine is also responsible for clearing the
update buffers when triggered in write mode.
.PP
The nature of setjmp/longjmp means that it appears to the calling
function as if the \fCISFAIL\fP call, made initially to initialise the
jump buffer, had returned \fCTRUE\fP.


