.TH "Dynamic Link Libraries" "7" "March 31" "disam_dynamic" "Byte Designs DISAM"


.SH Microsoft DLL
.PP
The most important distinction between unix and windows is that unix is
able to distinguish case in function names, while microsoft, apparently
to date, have decided otherwise - but only in Dynamic Link Libraries.
.PP
DISAM, perhaps unfortunately, relies on case to distinguish between the
base and the wrapper function calls.  Therefore, to build a windows DLL,
it is necessary to choose which interface(s) you wish to use, and build
dlls that export only the one interface. 
.PP
\fCISDYNAMIC\fP in isconfig.h\&
.SM [1]
\&
selects the type of dll you wish to build.
there are four choices available:
.br
\&
.SM [1]
\& disam_install.7.man
.br
.PP
.nf
\fC
  old 16 bit base interface                windows 3.1
  old 16 bit wrapper interface                windows 3.1
  current base interface                windows 95 and beyond
  current wrapper interface                 windows 95 and beyond
\fP
.fi
.PP
\fCISDYNAMIC 1 and 3\fP
for an older dynamic link library you will need a compiler that will
recognise the __far, __pascal and __export directives.  
.PP
\fCISDYNAMIC 2 and 4\fP
for a standard dynamic link library you will need a compiler that will
recognise the __declspec() directive.
.SH Unix Shared Libraries
.PP
For unix shared libraries you only need to set the appropriate PIC code,
usually -fpic in gcc, and proceed as for standard shared libraries.  In
this case you should use \fCISDYNAMIC\fP 0, although many unix compilers will
honour the declspec directive anyway, if the single interface approach
is preferred.


