.TH "isCheckVarlen" "3" "March 31" "isCheckVarlen" "Byte Designs DISAM"


.SH NAME
isCheckVarlen \- check the varlen storage of an ISAM file
.SH SYNOPSIS
.SS int isCheckVarlen( IsFile * \fIisfd\fP, struct isVarStat * \fIstats\fP );
\&
.TS
l l .
\fIisfd\fP 	 isam file descriptor 
\fIstats\fP 	 variable length statistics structure, defined in ischeck.h, or NULL to ignore same. 
\&
.TE
.SH RETURN
.PP
ISTRUE, or ISFALSE,
in which case the error code is returned by
isErrno\&
.SM [1]
\&, or found in
isfd->iserrno\&
.SM [2]
\&
.br
\&
.SM [1]
\& isErrno.3.man
.br
\&
.SM [2]
\& disam_error.7.man
.br
.SH NOTES
.PP
this routine checks the variable length storage system for
errors, and will return a value with the following bits set
in accordance with it's findings:
.PP
.nf
\fC
IC_VLMISFILE 12 node misfiled in hash table
IC_VLHASHLINK 13 mangled link in hash list
IC_VLMISSING 14 nodes missing or unaccounted
IC_VLBADDATA 15 data length mismatch
\fP
.fi
.PP
it will also optionally load the following fields in stats:
.PP
.nf
\fC
hashcount number of nodes held in hashtable
hashspace total bytes free space in same
fullcount number of nodes not in hashtable
fullspace total (unusable) space in same
filecount total number of storage nodes in use
filespace total free space for the file
\fP
.fi


