.TH "API wrap reference" "7" "March 31" "disam_apiwrap" "Byte Designs DISAM"


.PP
The library provides two separate interface methods.
.PP
The \fIwrap\fP (CISAM\(tm standard) interface is covered here, and passes isam
file handles as integer values, similar to the system open/write calls,
and it will be this interface that is described here.
.PP
The \fIbase\fP API is covered here\&
.SM [1]
\&.
.br
\&
.SM [1]
\& disam_apibase.7.man
.br
.SH Primary Details
.PP
The standard interface is provided in the form of an interface
layer, on top of the base library, to provides 'plug and play'
compatibility with existing cisam (or equivalent) code bases.
.PP
Only the differences between the
base and wrapper interfaces are explained below - you should refer
to the base library reference\&
.SM [2]
\& for the
remaining details.
.br
\&
.SM [2]
\& disam_apibase.7.man
.br
.SH The Integer Handle Wrapper
.PP
This interface is provided for those who prefer or require a cisam
compatible API.  This interface will link transparently with existing
cisam or cisam compatible application source, and should require no
changes to your code, other than to switch to the iswrap.h header.
.PP
All modules that use the integer wrapper should include \fIiswrap.h\fP
.PP
All function names are identical except that they use exclusively
lower case letters.
.PP
All parameters are identical except that an integer file handle is
used in place of the IsamFile structure pointer, and except for the
isbuild() call, which has the standard cisam arguments, whereas the
base version includes an extra argument for variable length support.
.PP
All functions return 0 on success, or -1 on error, with the exception
of isbuild and isopen, which return an integer file handle or -1 on
error.
.PP
\fCSUCCESS\fP and \fCERROR\fP are defined in the header and can be used to test
the returns from these calls.
.PP
\fCisrecnum\fP, \fCisreclen\fP, \fCiserrno\fP and \fCiserrio\fP are global variables declared
in the wrapper, defined as externals in \fCiswrap.h\fP and are maintained
in the same way as defined for the individual values in the base file
descriptors, and by the usual cisam standard.
.PP
Since the base library maintains an individual set of these variables
on a per file basis, we have also provided a collection of four calls
that will return a pointer to the associated variable:
.PP
.nf
\fC
  long *is_recnum( int isfd );
  int *is_reclen( int isfd );
  int *is_errno( int isfd );
  int *is_errio( int isfd );
\fP
.fi
.PP
These can be used to enquire or set values for individual files, and
are not overwritten on each isam call made.
.SH Common Dictionary Access
.PP
.nf
\fC
  char *isdi_name( int isfd );    file name as used in isopen/isbuild
  int isdi_datlen( int isfd );    fixed record length
  int isdi_curidx( int isfd );    current index number (zero based)
\fP
.fi
.PP
\fCisdi_name\fP returns a pointer to the file name string, or NULL if
the \fCisfd\fP value was invalid.  The remainder return an integer value
or -1 on failure.


