.TH "Null Key Masking" "7" "March 31" "disam_nullkeys" "Byte Designs DISAM"


.PP
It is possible to flag indexes such that null keys (those whose value
equates to null) will not be added to the index, and the associated
records will not be accessible via that index,
.PP
The default value used to determine if a given key is null is zero,
but this can be modified by adding the value, left shifted by eight,
to the key type field.
.PP
the following code constructs a null key index in which a character
field containing all spaces will be considered null:
.PP
.nf
\fC
      key->k_flags = ISDUPS + NULLKEY;
      key->k_nparts = 1;
      key->k_part[0].kp_type = CHARTYPE + ( 32 << 8 );
      key->k_part[0].kp_start = 10;       
      key->k_part[0].kp_leng = 10;
\fP
.fi
.PP
Null Key indexes are not cisam\(tm compatible.
.PP
Please see Index Masking\&
.SM [1]
\& for an alternate method of filtering indexes.
.br
\&
.SM [1]
\& disam_mask.7.man
.br


