.TH "Huge Files and 64bit types" "7" "March 31" "disam_huge" "Byte Designs DISAM"


.PP
As of version 7.1 support for 64bit \(lqhuge\(rq files is implicit, in the sense
that you should be able to set \fCISHUGE\fP 0 - which now means \(lqautomatic\(rq.
.PP
Your compiler needs to be \(lqmodern\(rq enough to know what an \(lqoff_t\(rq type is,
and what to do with it.  this should be true of most compilers these days.
.PP
If your compiler cannot identify an off_t data type, then you may need to
resign yourself to files not much bigger than 2GB each, because chances
are the rest of it's runtime is probably not too clever about big files
either.  In this case please contact us with your details, as there are
many ways around these problem, depending on the circumstances.
.PP
Given that your compiler knows about off_t, then:
.PP
If your compiler natively reports 32, but you want 64 support, then the
first thing to try is adding \(lq-D_FILE_OFFSET_BITS=64\(rq to your compiler
flags, and check to see if \fCsizeof(off_t)\fP returns \fC8\fP, as it should.
.PP
If that works then you should be good to go - make sure you are compiling
the library with _FILE_OFFSET_BITS set to 64, and run dcheck with no args
when done - it will test for the correct off_t, or fail the sanity check.
.PP
If your compiler does not recognise the implict method above, then you
will need to resort to ISHUGE 1 or 2, and/or try your chances with the
earlier _LARGEFILE_SOURCE methods, as per LFS (Large File Summit) API.
.PP
\fCISHUGE\fP 1 should be compatible with _LARGEFILE_SOURCE, in general.
.PP
\fCISHUGE\fP 2 switches to pread64 and pwrite64, if trouble with standard calls.
.PP
All of the changes are controlled via defines constructed in \fCbase/isport.h\fP
on the basis of \fCISHUGE\fP and the defines given above.


