.TH "Thread Safety" "7" "March 31" "disam_thread" "Byte Designs DISAM"


.SH Introduction
.PP
Support for multi-threading is provided on two levels.
.PP
The base level
implementation consists of a parallel collection of isam function calls
that operate on file descriptor structures (as opposed to the usual
integer file handles) and, other than requiring that you do not open
the same file more than once in any one process, is fully multi-thread
compatible without the requirement for critical section handling.
.PP
The second level option provides full cisam\(tm standard compatibility
and operates on the standard integer based file handles and associated
file descriptor table.  This option provides critical section (mutex)
handling for protection of the descriptor table and logic to provide
appropriate handling for duplicate opens on the same file within the
same process.  The mutex requirement impacts on the efficiency of the
library, but allows the use of the standard interface without losing
functionality.  There are two exceptions.
.PP
The four global variables - isrecnum, isreclen, iserrno and iserrio
are present and maintained, but should not be considered reliable.
Instead you should use the following function call equivalents:
.RS 8
.PP
long *is_recnum\&
.SM [1]
\&( int \fIisfd\fP ); 
.br
int *is_reclen\&
.SM [2]
\&( int \fIisfd\fP ); 
.br
int *is_errno\&
.SM [3]
\&( int \fIisfd\fP ); 
.br
int *is_errio\&
.SM [4]
\&( int \fIisfd\fP ); 
.br
.br
\&
.SM [1]
\& is_recnum.3.man
.br
\&
.SM [2]
\& is_reclen.3.man
.br
\&
.SM [3]
\& is_errno.3.man
.br
\&
.SM [4]
\& is_errio.3.man
.br
.RE
.PP
Note that these functions return pointers rather than values.  This
allows the application to both enquire and set the value, as in the
following examples:
.PP
.nf
\fC
  if( *is_errno( isfd ) == ENOREC ) /* record not found */

  *is_recnum( isfd ) = saved_record_number;
\fP
.fi
.PP
the equivalent core API functions are:
.RS 8
.PP
long *isRecnum\&
.SM [5]
\&( int \fIisfd\fP ); 
.br
int *isReclen\&
.SM [6]
\&( int \fIisfd\fP ); 
.br
int *isErrno\&
.SM [7]
\&( int \fIisfd\fP ); 
.br
int *isErrio\&
.SM [8]
\&( int \fIisfd\fP ); 
.br
.br
\&
.SM [5]
\& isRecnum.3.man
.br
\&
.SM [6]
\& isReclen.3.man
.br
\&
.SM [7]
\& isErrno.3.man
.br
\&
.SM [8]
\& isErrio.3.man
.br
.RE
.PP
The other exception applies to building variable length files.  The
standard isbuild call requires the use of a global isreclen value,
which is not threadsafe, so isvbuild\&
.SM [9]
\& covers this problem
by taking the maximum record length as an additional argument:
.br
\&
.SM [9]
\& isvbuild.3.man
.br
.PP
.nf
\fC
isvbuild( char *name, int fixlen, int maxlen, IsKdsc *key, int mode );
\fP
.fi
.PP
In the core API, isBuild\&
.SM [10]
\& takes an additional \fImlen\fP argument.
.br
\&
.SM [10]
\& isBuild.3.man
.br
.SH Please Note
.PP
When using second level support you must call isThreaded
from your root thread before starting any isam threads - this
will initialise the master mutex lock.
.PP
Under no circumstances, should the application
allow more than one thread to operate on the same isam file
handle at the same time.
.PP
isCleanUp\&
.SM [11]
\& and iscleanup\&
.SM [12]
\& are inherently not
threadsafe, and should only ever be called by the root thread after all isam
handling threads have terminated.
.br
\&
.SM [11]
\& isCleanUp.3.man
.br
\&
.SM [12]
\& iscleanup.3.man
.br
.PP
The transaction processing module is not entirely threadsafe.
.PP
Second level threadsafe under os2/warp is only marginally
supported.  There are a number of limitations imposed by the
fact that os2 only provides one critical section lock per
thread.  At time of writing the library will occasionally
deadlock under heavy use.  We are researching a solution to
this problem but at the same time are hoping that ibm will
improve threaded support before it becomes an issue.  If you
require second level threadsafe operation under os2 please
stand up and be counted by contacting the support department.
.SH isThreaded
.PP
int isThreaded( \fIvoid\fP )
.PP
\fBRETURN\fP 
.br
.RS 8
currently isThreaded and isThreadedDone return true always,
but this may change in future, so perhaps it is best to check.
.RE
.PP
\fBNOTES\fP 
.br
.RS 8
isThreaded intialises the master mutex lock, and this is
essential if you require second level thread safety.
.RE
.SH Installation
.PP
In order to make use of the base level implementation, the only thing
you need to do is to compile a library with the \fCISADMIN\fP feature turned
off.  This is because the administration functions make use of global
tables which would not be safe in a non-mutexed environment.  Use of
this implementation implies that you will be making base library calls,
as detailed in API base reference\&
.SM [13]
\&, and that you do not
plan to allow your applications to open the same file more than once.
.br
\&
.SM [13]
\& disam_apibase.7.man
.br
.PP
To build a second level library you will need to turn the \fCISADMIN\fP
feature on, and make a choice from the four options currently given
in isconfig.h\&
.SM [14]
\& as to which \fCISTHREADED\fP
flavour your target will use.
.br
\&
.SM [14]
\& disam_install.7.man
.br
.PP
If your thread handling library uses a different series of calls or semantics than
those covered, you might wish to take a look at \fChead/isthread.h\fP, since the
porting procedure is relatively simple.  In all cases we will be glad
to offer advice in exchange for the opportunity to add more platforms
to the list of those supported.


