.TH "The CISAM standards" "7" "March 31" "disam_cisam" "Byte Designs DISAM"


.PP
\fBUpgrading from CISAM\(tm\fP
.PP
The process of upgrading from cisam should be as simple as relinking
with the new library, however there are a few things you will need to
sort out first.
.SH The header file
.PP
\fCisam.h\fP is the CISAM standard header file, the DISAM equivalent is \fChead/iswrap.h\fP
.PP
You have three basic alternatives:
.RS 4
.IP 1. 4
\&Modify your application code to include \fCiswrap.h\fP in place of \fCisam.h\fP
.IP 2. 4
\&(Move aside and) replace \fCisam.h\fP with a copy of \fCiswrap.h\fP
.IP 3. 4
\&Create a new copy of \fCisam.h\fP which does nothing more than include
either \fCiswrap.h\fP or a renamed or relocated copy of \fCisam.h\fP, based
on an \fC#ifdef\fP condition.  This would permit you to easily switch back
and forth, as needed.
.RE
.SH What happens when the current key changes on rewrites
.PP
The best way to explain this is by example.  Assume you have a file
containing the following records: \fIAAA\fP, \fIBBB\fP, \fICCC\fP, \fIEEE\fP,
and that the current index is based on these values.
.PP
Under cisam, if \fIAAA\fP was the current record and you were to change
it's contents to \fIDDD\fP and rewrite, an isread or isstart with a mode
of \fCISNEXT\fP would set the current to \fIEEE\fP.
.PP
This can be somewhat problematic if you are doing a read next loop
through your file, so we have arbitrarily adjusted this behaviour
to ensure that the next record found will follow the current as set
\fIbefore\fP the rewrite.
.PP
This means that, given the above example, \fIBBB\fP would become current
on an isread or isstart with a mode of \fCISNEXT\fP.
.PP
The same (in reverse) is true when reading backwards through the
file with a mode if \fCISPREV\fP.
.PP
We currently consider this behaviour to be an enhancement over the
cisam standard, but would be happy to provide true cisam operation
if anyone should ask for it.  please contact the support department
if this is important to you.
.SH CISAM autolock / nowait 
.PP
For cisam compatible nowait on open and automatic record locks set
\fCC7NOWAIT\fP to 1 in isconfig.h\&
.SM [1]
\&
.br
\&
.SM [1]
\& disam_install.7.man
.br
.SH CISAM version 5.0 through 7.1 locking concurrency
.PP
For cisam version 5.0 through 7.1 locking concurrency, when running
in parallel with cisam binaries, set \fCC7LOCKING\fP to 1 in
isconfig.h\&
.SM [2]
\&
.br
\&
.SM [2]
\& disam_install.7.man
.br
.PP
Please bear in mind that binaries linked against a library with \fCC7LOCKING\fP set to 1
will no longer run concurrent with binaries linked against standard DISAM locking.
.SH CISAM version 7.2x locking concurrency
.PP
As above, except \fCC7LOCKING\fP should be set to 2.


