.TH "Index Masking" "7" "March 31" "disam_mask" "Byte Designs DISAM"


.PP
Index masking is a mechanism through which the application can control
which indexes a given record will be stored in.  Usage is relatively
simple, and best explained by example.
.PP
Masked files are created by adding \fCISMASKED\fP to the mode when calling
isBuild\&
.SM [1]
\& or isbuild\&
.SM [2]
\&, and are opened in the same way.
.br
\&
.SM [1]
\& isBuild.3.man
.br
\&
.SM [2]
\& isbuild.3.man
.br
.PP
The library will return an \fCEBADARG\fP error if a masked file is opened
without \fCISMASKED\fP in the mode or \fCISMASKED\fP is added to the open mode
on an unmasked file.
.PP
Given a file with three indexes, where a value of 1 represents the
primary, 2 the middle index, and 3 the last, the following call will
add a record to the primary index only:
.PP
.nf
\fC
  issetmask( isfd, ISMASK(2) + ISMASK(3) );
  iswrite( isfd, record_data );
\fP
.fi
.PP
To rewrite a record such that it will be masked in the primary:
.PP
.nf
\fC
  issetmask( isfd, ISMASK(1) );
  isrewrite( isfd, record_data );
\fP
.fi
.PP
isrewrite\&
.SM [3]
\& could also be isrewcurr\&
.SM [4]
\& or isrewrec\&
.SM [5]
\&.
isRewrite\&
.SM [6]
\& could also be isRewCurr\&
.SM [7]
\& or isRewRec\&
.SM [8]
\&.
.br
\&
.SM [3]
\& isrewrite.3.man
.br
\&
.SM [4]
\& isrewcurr.3.man
.br
\&
.SM [5]
\& isrewrec.3.man
.br
\&
.SM [6]
\& isRewrite.3.man
.br
\&
.SM [7]
\& isRewCurr.3.man
.br
\&
.SM [8]
\& isRewRec.3.man
.br
.PP
The mask value for the current record can be obtained via a call to
.PP
.nf
\fC
  isgetmask( isfd );
\fP
.fi
.PP
Record masks must be set explicitly - if reading through a file with
the intention of adjusting mask values you must call issetmask for
each record you wish to change.
.PP
Files built with masking active will allow multiple copies of
identical indexes to be added to the file.  This is to allow the
developer to store different record subsets in separate indexes,
but it is important to note that only the \fBlast\fP of these indexes
can be accessed via \fCisstart\fP.  \fCisindex\fP should be used instead.
.PP
If using the base\&
.SM [9]
\& API calls you should enquire
and set the mask values directly, rather than using \fCisgetmask\fP
and \fCissetmask\fP.  For example:
.br
\&
.SM [9]
\& disam_apibase.7.man
.br
.PP
.nf
\fC
  if( isam->mask & ISMASK(1) ) /* current record masked in primary */

  isam->mask = ISMASK(2) + ISMASK(3); /* mask 2nd and 3rd indexes */
\fP
.fi
.PP
Masking is a custom extension - files built with ISMASKED are
not cisam\(tm compatible.
.PP
You should not remove indexes from a masked file once it has
been populated.
.PP
As of version 6.1, the flag in the index header that denotes
masked files has been changed - you will need to run fixflags
(available from Sales and Support\&
.SM [10]
\&) to patch older files.
.br
\&
.SM [10]
\& disam_support.7.man
.br
.PP
See Null Key Masking\&
.SM [11]
\& for an alternate method of filtering indexes.
.br
\&
.SM [11]
\& disam_nullkeys.7.man
.br


