.TH "Pure Indexes" "7" "March 31" "disam_pure" "Byte Designs DISAM"


.SH Introduction
.PP
Pure index files provide a method of managing key information without
the overheads required for full data handling.  They offer advantages
in speed and storage requirements, but are necessarily limited in
other ways.
.PP
Both isBuild and isbuild will create pure index files when passed a
value of zero for the record length.  The result is a single index
(.idx) file - no data store (.dat) is created.
.SH Notes
.PP
Pure index files consist of the primary index only - you may not add
secondary indexes.
.PP
Only the fields pointed to by the key description will be stored and
available for retrieval.
.PP
The current value of isrecnum will be stored on writes and updates,
and will be returned on read. 
.PP
This permits the application to store an arbitrary value, perhaps
pointing to a related record in another isam file, or in some other
record store, or perhaps a counter, or a timestamp, etc.
.PP
Record locking is not possible, and pure indexes may not be opened in
autolock mode.
.PP
you cannot delete or rewrite by record number.
.PP
pure indexes cannot be rebuilt or repaired if damaged, so should not
be used for critical data.
.SH Sequential Record Numbering
.PP
Setting ISPURE to 1 in isconfig.h\&
.SM [1]
\&
will insert a call to store a sequential value for isrecnum.
.br
\&
.SM [1]
\& disam_install.7.man
.br
.PP
This will occur on all new inserts, across all existing pure indexes,
on a global basis, and should probably not be changed if you are
already using pure indexes for other purposes.
.PP
This method is based on a simple increment, and does not adjust for
or reuse deleted record numbers, as with regular isam files.


